﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;

namespace CommunicationSupport
{
    [Serializable]
    internal class ServiceMethodInfo
    {
        #region Memebers
        
        MethodInfo _method;
        
        #endregion

        #region Constructors

        public ServiceMethodInfo() { }

        public ServiceMethodInfo(MethodInfo method)
        {
            SetMethod(method);
        }

        #endregion

        #region Properties


        public MethodInfo Method
        {
            get { return _method; }
            set
            {
                SetMethod(value);
            }
        }

        public Dictionary<string,ParameterInfo> Parameters { get; private set; }
        
        #endregion

        #region Private Methods

        void SetMethod(MethodInfo method)
        {
            _method = method;
            Parameters = null;
            if (_method != null)
                AssignParameters(method.GetParameters());
        }

        void AssignParameters(ParameterInfo[] parameters)
        {
            Parameters = new Dictionary<string, ParameterInfo>();
            
            foreach (ParameterInfo parameter in parameters)
            {
                Parameters.Add(parameter.Name, parameter);
            }
        }

        #endregion
    }

}
